package net.w_horse.excelpojo;


import org.apache.log4j.xml.DOMConfigurator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.junit.BeforeClass;

public abstract class AbstractTest {


	@BeforeClass
	public static void tearDown() {
		DOMConfigurator.configure("config/log4j.xml");
	}

	protected Cell getCell(Sheet sheet, int rowIndex, int colIndex) {
		Row row = sheet.getRow(rowIndex -1);
		if (row == null) return null;
		return row.getCell(colIndex -1);
	}
	protected Object getCellValue(Sheet sheet, int rowIndex, int colIndex,
			int cellType) {
		return getCellValue(getCell(sheet, rowIndex, colIndex), cellType);
	}

	protected static final int CELL_TYPE_STRING = 0;
	protected static final int CELL_TYPE_INT = 1;
	protected static final int CELL_TYPE_DOUBLE = 2;
	protected static final int CELL_TYPE_DATE_STR = 3;
	protected static final int CELL_TYPE_BOOLEAN = 4;
	protected static final int CELL_TYPE_DATE = 5;

	public AbstractTest() {
		super();
	}

	protected Object getCellValue(Cell cell, int cellType) {
		// NULL͋󕶎ϊ
		if(cell == null){
			return null;
		}

		switch(cellType){
		case CELL_TYPE_STRING:
		case CELL_TYPE_DATE_STR:
			return cell.getRichStringCellValue().getString();
		case CELL_TYPE_DATE:
			return cell.getDateCellValue();
		case CELL_TYPE_INT:
		case CELL_TYPE_DOUBLE:
			return getNumericType(cell, cellType);
		case CELL_TYPE_BOOLEAN:
			return cell.getBooleanCellValue();
		default:
			return null;
		}
	}

	private Object getNumericType(Cell cell, int cellType) {
		DataFormatter formatter = new DataFormatter();
	    String val = formatter.formatCellValue(cell);
	    if (val.endsWith("_ ")) {
	    	val = val.substring(0, val.length() -2);
	    }
	    if (cellType == CELL_TYPE_INT) {
	    	return Integer.parseInt(val);
	    } else {
	       	return Double.parseDouble(val);
	    }
	}

}